# -*- coding: utf-8 -*-
from logging import getLogger

from cachetools.func import ttl_cache
from django.conf import settings
from feature_flag_client import Client

__feature_flags_client = Client(
    host=settings.FEATURE_FLAG_HOST,
    service_code='pretty-fares',
    logger=getLogger('feature_flag_client')
)


@ttl_cache(maxsize=None, ttl=5 * 60)
def save_minprices_to_airports():
    # type: () -> bool

    return not __feature_flags_client.create_context().flag_enabled(
        'DISABLE_SAVE_MINPRICES_TO_AIRPORTS'
    )
