# -*- coding: utf-8 -*-
import logging
import uuid
from datetime import datetime

import requests
from django.conf import settings

log = logging.getLogger(__name__)


def send_to_db(query, json_result):
    if settings.PRICE_INDEX_HOST is None:
        log.warn('Task will skip, because price index host is none')
        return
    session_id = str(uuid.uuid4())
    now = datetime.now()

    try:
        (
            point_from, point_to,
            date_forward, date_backward,
            klass,
            adults, children, infants,
            national_version
        ) = query.split('_')

        if point_from and not point_from.startswith('c'):
            log.info(
                'SKIP: From Point must be a settlement: [%s]', point_from
            )
            return
        else:
            point_from = point_from[1:]

        if point_to and not point_to.startswith('c'):
            log.info(
                'SKIP: To Point must be a settlement: [%s]', point_to
            )
            return
        else:
            point_to = point_to[1:]

        if klass != 'economy':
            log.info('Klass type must be economy: %s', klass)
            return

        if date_backward != 'None':
            part_route = (
                point_from, point_to,
                date_forward, date_backward,
                national_version,
                adults,
                children,
                infants
            )
        else:
            part_route = (
                point_from, point_to,
                date_forward,  # date_backward,
                national_version,
                adults,
                children,
                infants
            )

        log.info('start: %s', session_id)
        res = requests.post(
            '{}/index_methods/v1/index/{}'.format(settings.PRICE_INDEX_HOST, '/'.join(part_route)),
            data=json_result,
            timeout=5
        )
        res.raise_for_status()
        log.info(
            'end: %s %s',
            session_id,
            (datetime.now() - now).total_seconds()
        )
    except Exception as e:
        log.exception(
            'can not send to db: %r %s %r',
            e, session_id, (datetime.now() - now).total_seconds()
        )
