# -*- coding: utf-8 -*-
import os

from travel.avia.library.python.common.settings import EnvironmentSettings


PRICE_INDEX_HOST = None

CELERY_ROUTES = {
    'pretty_fares.messaging.tasks.store_processed_qid': {
        'exchange': 'td_qid_ex',
        'routing_key': 'store_qid',
        'queue': 'federated_qid_ticket_daemon',
    },
    'pretty_fares.messaging.tasks.store_variants_to_price_index': {
        'exchange': 'pretty_fares_ex_price_index_variants',
        'routing_key': 'price_index_variants',
        'queue': 'federated_price_index_variants',
    },
}
CELERY_QUEUES = {
    'federated_qid_ticket_daemon': {
        'binding_key': 'store_qid',
        'exchange': 'td_qid_ex',
        'exchange_type': 'direct',
        'queue_arguments': {'x-max-length': 1000},
    },
    'federated_wizard_variants': {
        'binding_key': 'wizard_variants',
        'exchange': 'pretty_fares_ex_wizard_variants',
        'exchange_type': 'direct',
        'queue_arguments': {'x-max-length': 5000},
    },
    'federated_price_index_variants': {
        'binding_key': 'price_index_variants',
        'exchange': 'pretty_fares_ex_price_index_variants',
        'exchange_type': 'direct',
        'queue_arguments': {'x-max-length': 1000},
    }
}


def apply_environment_settings(settings, conductor):
    EnvironmentSettings.apply(settings, conductor)
    env_type = settings['YANDEX_ENVIRONMENT_TYPE']

    if env_type == 'development':
        settings['DATABASES']['default']['HOST'] = os.getenv('AVIA_MYSQL_HOST', 'localhost')
        settings['DATABASES']['default']['NAME'] = os.getenv('AVIA_MYSQL_DATABASE', 'avia')
        settings['DATABASES']['default']['USER'] = os.getenv('AVIA_MYSQL_USER', 'root')
        settings['DATABASES']['default']['PASSWORD'] = os.getenv('AVIA_MYSQL_PASSWORD', '')

    settings['WIZARD_CACHE_PREFIX'] = '/{}/pretty_fares/wizard'.format(env_type)
    settings['WIZARD_CACHE_PREFIX_WITH_AIRPORTS'] = '/{}/pretty_fares/wizard/with_airports'.format(env_type)

    settings['PRICE_INDEX_HOST'] = os.getenv('AVIA_PRICE_INDEX_HOST')
    settings['TICKET_DAEMON_HOST'] = os.getenv('AVIA_TICKET_DAEMON_HOST')
    settings['BACKEND_HOST'] = os.getenv('AVIA_BACKEND_HOST', 'backend.production.avia.yandex.net')

    # unused settings
    settings['SAAS_INDEX_HOST'] = ''
    settings['SAAS_SEARCH_HOST'] = ''
    settings['SAAS_SERVICE_KEY'] = ''
    settings['SAAS_SERVICE_NAME'] = ''
