# -*- coding: utf-8 -*-
# flake8: noqa
import urllib2

import json

from travel.avia.library.python.common.settings.db import *
from travel.avia.library.python.common.settings.misc import *
from travel.avia.library.python.common.settings.managed import *
from travel.avia.library.python.avia_data.settings import *


YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE')
ETC_PATH = '/etc/yandex/rasp'
LOG_PATH = '/var/log/yandex-avia-td-processing/'

CELERY_ACCEPT_CONTENT = ['pickle']
CELERY_TASK_SERIALIZER = 'pickle'
# Management: http://www.rabbitmq.com/management.html
# http://docs.celeryproject.org/en/latest/userguide/routing.html#manual-routing

# CELERYD_LOG_FILE = '/var/log/yandex-avia-td-processing/main/celery.log'

CELERY_ENABLE_UTC = False
TIME_ZONE = 'Europe/Moscow'

CELERY_DEFAULT_QUEUE = 'pretty_fares_celery_default_queue'
CELERY_DEFAULT_EXCHANGE = 'pretty_fares_celery'
CELERY_DEFAULT_EXCHANGE_TYPE = 'direct'
CELERY_DEFAULT_ROUTING_KEY = 'task.default'
CELERYD_HIJACK_ROOT_LOGGER = False

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',

    'travel.avia.library.python.common',
    'travel.avia.library.python.avia_data',
    'travel.avia.library.python.common.app_stubs.www',
    'travel.avia.library.python.common.app_stubs.currency',
    'travel.avia.library.python.common.app_stubs.order',

    'travel.avia.ticket_daemon_processing.pretty_fares',
)

WIZARD_CACHE_PREFIX = '/testing/pretty_fares/wizard'
WIZARD_CACHE_PREFIX_WITH_AIRPORTS = '/testing/pretty_fares/wizard/with_airports'

JSENDAPI_TIMEOUT = 10

VARIANT_TTL_IN_HOURS = 12


def _request(app, env):
    headers = {
        'Authorization': 'OAuth {}'.format(os.getenv('QLOUD_API_OAUTH_TOKEN')),
        'Content-type': 'application/json',
    }
    url = 'https://platform.yandex-team.ru/api/v1/environment/stable/avia.{app}.{env}'
    request = urllib2.Request(url.format(app=app, env=env), headers=headers)
    content = urllib2.urlopen(request).read()
    return json.loads(content)


def __format_object_id(object_id):
    """reorder 'avia.rabbitmq.testing.server' to 'server.testing.rabbitmq.avia'"""
    return '.'.join(object_id.split('.')[::-1])


def get_qloud_hosts(app, env):
    """Отдаем в первую очередь хосты в своём ДЦ"""
    response = _request(app, env)
    broker_hosts = []
    qloud_dc = os.getenv('QLOUD_DATACENTER').lower()
    for component, component_info in response['components'].items():
        object_id = __format_object_id(component_info['objectId'])
        for instance in component_info['runningInstances']:
            host = '{instance_id}.{object_id}.stable.qloud-d.yandex.net'.format(
                instance_id=instance['instanceId'],
                object_id=object_id
            )
            if instance['host'].startswith(qloud_dc):
                yield host
            else:
                broker_hosts.append(host)

    for host in broker_hosts:
        yield host


if YANDEX_ENVIRONMENT_TYPE in {'testing', 'production'}:
    rmq_user = os.getenv('RABBITMQ_USER')
    rmq_password = os.getenv('RABBITMQ_PASSWORD')
    rmq_port = 5672
    BROKER_URL = [
        'amqp://{}:{}@{}:{}//'.format(rmq_user, rmq_password, rmq_host, rmq_port)
        for rmq_host in get_qloud_hosts('rabbitmq', YANDEX_ENVIRONMENT_TYPE)
    ]

    ZOOKEEPER_HOSTS = list(get_qloud_hosts('zookeeper', YANDEX_ENVIRONMENT_TYPE))
else:
    BROKER_URL = os.getenv('BROKER_URL')  # Use env variable BROKER_URL for development
    ZOOKEEPER_HOSTS = [os.getenv('ZOOKEEPER_HOST')]
