#!/usr/bin/env bash

case "$(< /etc/yandex/environment.type)" in
"production")
    group=avia_rabbitmq_ticketdaemon;
    ;;
"testing")
    group=avia_test_rabbitmq_ticketdaemon
    ;;
*)
    group=dev.avia_rabbitmq_ticketdaemon
    ;;
esac


curl -sS -u guest:guest 'http://localhost:15672/api/queues' |
python3 -c "
import json, sys

def flatten(dictionary, prefix=''):
    for key, value in dictionary.items():
        if prefix:
            key = '{}.{}'.format(prefix, key)

        if type(value) in {int, float}:
            yield key, value
        if isinstance(value, dict):
            yield from flatten(value, prefix=key)

for queue in json.load(sys.stdin):
    for key, count in flatten(queue, prefix=queue['name']):
        print('--values={}={}'.format(key, count))
" |
xargs /usr/bin/agavesend --prefix geo.avia --group="$group" --fieldset queues
