# -*- coding: utf-8 -*-
import json
import logging
import os
import socket
import subprocess
import sys
import time


logging.basicConfig(
    format=u'%(levelname)-8s [%(asctime)s] %(message)s',
    level=logging.INFO,
    filename=os.path.join(os.getenv('AVIA_LOG_PATH'), 'main', '{}.log'.format(os.path.basename(__file__)[:-3])))

send_fmt = 'echo geo.avia.{group}.{hostname}.wizard_tasks.delivery_duration.{metric} {value} {unixtime} | nc localhost 42000'


def send(**kwargs):
    subprocess.check_call(send_fmt.format(**kwargs), shell=True)


def percentile(data, q=(50, 90, 95, 99, 100)):
    assert len(data), 'data cannot be empty'
    d = sorted(data)
    res = []
    for percent in q:
        pos = int(percent) * (len(data) - 1) / 100
        res.append(d[pos])
    return res


def calculate_duration_metrics(data):
    unixtime_now = int(time.time())
    q = (50, 90, 95, 99, 100)
    durations = [row['duration'] for row in data]
    for metric, value in zip(q, percentile(durations, q=q)):
        yield 'delivery_duration_sec_%d_prc' % metric, value, unixtime_now


def main():
    env = os.getenv('YANDEX_ENVIRONMENT_TYPE')
    hostname = socket.gethostname().replace('.', '_')
    if '_dev' in hostname:
        return
    if env == 'production':
        group = 'avia_rabbitmq_ticketdaemon'
    elif env == 'testing':
        group = 'avia_test_rabbitmq_ticketdaemon'
    else:
        group = 'dev.avia_rabbitmq_ticketdaemon'

    data = map(json.loads, sys.stdin)

    if not data:
        logging.info('No data found')
        return

    for metric_name, value, unixtime in calculate_duration_metrics(data):
        send(
            group=group,
            hostname=hostname,
            metric=metric_name,
            value=value,
            unixtime=unixtime
        )


if __name__ == '__main__':
    logging.info('Start')
    try:
        main()
    except Exception, exc:
        logging.exception('Exception %r on updating metrics', exc)
        raise
    logging.info('Done')
