#!/usr/bin/env bash

if [ "$#" -ne 2 ]; then
    echo "Usage: timetail.sh filename seconds"
    exit 1
fi


filename="$1"
seconds="$2"

tac "$filename" | python -c "
import json
import sys
from datetime import datetime, timedelta
min_dt = datetime.utcnow() - timedelta(seconds=$seconds)
for line in sys.stdin:
    if datetime.utcfromtimestamp(json.loads(line)['unixtime']) < min_dt:
        break
    sys.stdout.write(line)
"
