import asyncio
import logging
import os

from aiohttp import web

from travel.avia.ticket_daemon_processing.server import settings

logger = logging.getLogger(__name__)


async def version(request):
    return web.Response(status=200, text='Package tag: {}\nPackage hash: {}\n'.format(
        os.getenv('QLOUD_DOCKER_IMAGE'), os.getenv('QLOUD_DOCKER_HASH')
    ))


async def ping(request):
    ok = await check_celery_status()
    if ok:
        return web.Response(text='ok', status=200)
    else:
        return web.Response(text='error', status=500)


async def check_celery_status():
    cmd = 'supervisorctl status'
    proc = await asyncio.create_subprocess_shell(
        cmd,
        stdout=asyncio.subprocess.PIPE,
        stderr=asyncio.subprocess.PIPE,
    )
    stdout, stderr = await proc.communicate()

    if not proc.returncode and not stderr and stdout:
        celery_lines = [line.strip() for line in stdout.decode().split('\n') if 'celery' in line]
        if celery_lines and all('RUNNING' in l for l in celery_lines):
            return True

    logger.error(f'"{cmd}" return code "{proc.returncode}", stderr "{stderr.decode()}", stdout "{stdout.decode()}"')
    return False


def main():
    settings.setup_logging()

    routes = [
        web.get('/ping', ping),
        web.get('/version', version),
    ]

    app = web.Application()
    app.add_routes(routes)
    web.run_app(app, port=settings.SERVER_PORT)
