PY2_LIBRARY(ticket-daemon-processing)

OWNER(g:avia)

PEERDIR(
    # Avia dependencies
    travel/library/python/avia_mdb_replica_info
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/avia_data
    travel/avia/library/python/common
    travel/avia/library/python/common/saas/proto

    # Yandex dependencies
    library/python/blackbox
    library/python/django

    # Other dependencies
    contrib/python/protobuf
    contrib/python/Babel
    contrib/python/cachetools
    contrib/python/celery
    contrib/python/dateutil
    contrib/python/decorator
    contrib/python/django/django-1.11
    library/python/django_template_common
    contrib/python/ipython
    contrib/python/kazoo
    contrib/python/MySQL-python
    contrib/python/parameterized
    contrib/python/pytils
    contrib/python/pytz
    contrib/python/raven
    contrib/python/retrying
    contrib/python/scour
    contrib/python/six
    contrib/python/typing
    library/python/ylock
)

PY_SRCS(
    app.py
    local_settings.py
    migration_settings.py
    pretty_fares/__init__.py
    pretty_fares/errors_handling/__init__.py
    pretty_fares/errors_handling/safe_run.py
    pretty_fares/internal_logic/__init__.py
    pretty_fares/internal_logic/direction_cheapest_updater.py
    pretty_fares/internal_logic/direction_key.py
    pretty_fares/internal_logic/helpers.py
    pretty_fares/internal_logic/point_key.py
    pretty_fares/kazoo_lock.py
    pretty_fares/lib/__init__.py
    pretty_fares/lib/feature_flags.py
    pretty_fares/messaging/__init__.py
    pretty_fares/messaging/daemon_filter.py
    pretty_fares/messaging/daemon_tasks.py
    pretty_fares/messaging/db_tasks.py
    pretty_fares/messaging/tasks.py
    pretty_fares/messaging/wizard_tasks.py
    pretty_fares/models_utils/__init__.py
    pretty_fares/models_utils/geo.py
    pretty_fares/models_utils/popularities.py
    pretty_fares/saas.py
    pretty_fares/settings/__init__.py
    pretty_fares/settings/environment.py
    pretty_fares/settings/main.py
    scripts/send_wizard_tasks_metrics.py
)

END()

RECURSE_FOR_TESTS(
    tests
)

RECURSE(
    bin
    server
)
