# -*- encoding: utf-8 -*-
from travel.avia.travelers.application.handlers import BaseHandler
from travel.avia.travelers.application.validations.document_types import DOCUMENT_SETTINGS
from travel.avia.travelers.application.schemas import DocumentTypeSettingsSchema

document_schema = DocumentTypeSettingsSchema()


class DocumentTypesHandler(BaseHandler):
    def get(self):
        result = {}
        for t, v in DOCUMENT_SETTINGS.items():
            result[t.name] = document_schema.dump(v)
        self.write(result)
