# -*- encoding: utf-8 -*-
class DataSyncError(RuntimeError):
    pass


class ForbiddenDataSyncError(DataSyncError):
    pass


def data_sync_exceptions(logger):
    def decorator(func):
        def wrapper(self, *args, **kwargs):
            try:
                func(self, *args, **kwargs)
            except ForbiddenDataSyncError as e:
                logger.exception(e)
                self.send_error(403, reason='Invalid user ticket')
            except DataSyncError as e:
                logger.exception(e)
                self.send_error(500, reason='DataSync internal error')

        return wrapper

    return decorator
