# -*- encoding: utf-8 -*-
from http_geobase import Client as GeobaseClient
from http_geobase.models import GeobaseRegion


class GeoDataClient(object):
    _instance = None

    def __init__(self):
        countries = GeobaseClient().regions_by_type(3)
        self._country_by_geo_id = {int(c.id): c for c in countries}
        self._country_by_iso_name = {c.iso_name: c for c in countries}

    @classmethod
    def get_instance(cls):
        if cls._instance:
            return cls._instance
        cls._instance = cls()
        return cls._instance

    def country_by_geo_id(self, geo_id: int) -> GeobaseRegion:
        return self._country_by_geo_id.get(geo_id)

    def country_by_iso_name(self, iso_name: str) -> GeobaseRegion:
        return self._country_by_iso_name.get(iso_name)


def init_geo_data_client():
    GeoDataClient.get_instance()
