# -*- encoding: utf-8 -*-
import os
import pathlib
import logging.config
from logging.handlers import WatchedFileHandler

from cloud_logger import default_config

from jaeger_client.constants import SAMPLER_TYPE_PROBABILISTIC

CURRENT_DC = os.getenv('DEPLOY_NODE_DC', None)
YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', None)

LOG_PATH = os.getenv('AVIA_LOG_PATH', '/var/log/yandex-avia-travelers')

WORKERS = int(os.getenv('AVIA_TORNADO_WORKERS', 1))
SOCKET_PATH = os.getenv('AVIA_TORNADO_SOCKET', '/tmp/travelers.sock')

SENTRY_URL = os.getenv('AVIA_SENTRY_URL', None)

TVM_SERVICE_ID = os.getenv('AVIA_TRAVELERS_TVM_SERVICE_ID', None)
TVM_SECRET = os.getenv('TVMTOOL_LOCAL_AUTHTOKEN', os.getenv('AVIA_TRAVELERS_TVM_SECRET', None))

DATA_SYNC_API_URL = os.getenv('AVIA_DATA_SYNC_API_URL', None)
DATA_SYNC_TVM_SERVICE_ID = os.getenv('AVIA_DATA_SYNC_TVM_SERVICE_ID', None)

PING_SHUTDOWN_FLAG_FILENAME_TEMPLATE = '/tmp/avia_travelers_shutdown_flag_{pid}'

FEATURE_FLAG_CACHE_TTL = 5 * 60
FEATURE_FLAG_HOST = os.getenv('AVIA_FEATURE_FLAG_HOST', None)

VERSION = os.getenv('DEPLOY_DOCKER_IMAGE', ':unknown').rsplit(':', 1)[-1]
TRACING_SERVICE_NAME = 'avia-travelers'
TRACING_JAEGER_SAMPLER_TYPE = os.getenv('JAEGER_SAMPLER_TYPE', SAMPLER_TYPE_PROBABILISTIC)
TRACING_JAEGER_SAMPLER_PARAMETER = float(os.getenv('JAEGER_SAMPLER_PARAMETER', 0.001))

YT_REQUEST_LOG = os.getenv('AVIA_TRAVELERS_YT_REQUEST_LOG', os.path.join(LOG_PATH, 'yt/request.log'))


def setup_logging():
    from raven.conf import setup_logging as raven_setup_logging
    from raven.handlers.logging import SentryHandler

    from travel.avia.library.python.error_booster.raven.unified_agent import RavenErrorBoosterUnifiedAgentClient

    pathlib.Path(LOG_PATH).mkdir(parents=True, exist_ok=True)
    logging.config.dictConfig(default_config(LOG_PATH))

    pathlib.Path(YT_REQUEST_LOG).parent.mkdir(parents=True, exist_ok=True)
    _yt_request_logger = logging.getLogger('yt.request')
    _yt_request_logger.setLevel(logging.INFO)
    _yt_request_logger.addHandler(WatchedFileHandler(YT_REQUEST_LOG))
    _yt_request_logger.propagate = False

    error_booster_host = os.getenv('ERROR_BOOSTER_HTTP_HOST', None)
    error_booster_port = os.getenv('ERROR_BOOSTER_HTTP_PORT', None)

    if error_booster_host and error_booster_port:
        raven_client = RavenErrorBoosterUnifiedAgentClient(
            error_booster_host=error_booster_host,
            error_booster_port=error_booster_port,
            service='travelers',
            environment=YANDEX_ENVIRONMENT_TYPE,
            dc=CURRENT_DC,
        )
        sentry_handler = SentryHandler(raven_client)
        sentry_handler.setLevel(logging.WARNING)
        raven_setup_logging(sentry_handler)
