# -*- encoding: utf-8 -*-
import re

from marshmallow import ValidationError


class ValidationSettings(object):
    def __init__(self, required, unused, re_validations):
        assert isinstance(required, list), '"required" should be a list'
        assert isinstance(unused, list), '"unused" should be a list'
        assert isinstance(re_validations, dict), '"validations" should be a dict'

        self.required = required
        self.unused = unused
        self.re_validations = re_validations

        self.re_validations_compiled = {}
        for f, v in self.re_validations.items():
            self.re_validations_compiled[f] = re.compile(v, re.UNICODE)


def validate_with_settings(data, validation_settings):
    # type: (dict, ValidationSettings) -> None

    errors = dict()
    for f in validation_settings.required:
        if f not in data or not data[f]:
            errors[f] = ['Required field']

    for f, validation in validation_settings.re_validations_compiled.items():
        if f in data and not validation.match(data[f]):
            errors[f] = ['Wrong field']

    if len(errors) > 0:
        raise ValidationError(message=errors)
