# -*- encoding: utf-8 -*-
from enum import Enum

from travel.avia.travelers.application.validations import ValidationSettings


class BonusCardType(Enum):
    universal_road = 'universal_road'
    rzd_bonus = 'rzd_bonus'
    avia_company_loyalty = 'avia_company_loyalty'


BONUS_CARD_SETTINGS = {
    BonusCardType.rzd_bonus: ValidationSettings(
        required=['number'],
        unused=['title'],
        re_validations={
            'number': r'^\d{13}$',
        },
    ),
    BonusCardType.universal_road: ValidationSettings(
        required=['number'],
        unused=['title'],
        re_validations={
            'number': r'^\d{13}$',
        },
    ),
    BonusCardType.avia_company_loyalty: ValidationSettings(
        required=['number'],
        unused=['title'],
        re_validations={},
    ),
}
