# -*- encoding: utf-8 -*-
from enum import Enum

from travel.avia.travelers.application.validations import ValidationSettings

REGEXP_RU_NAME = r'^[а-яёА-ЯЁ \'\-]*$'
REGEXP_EN_NAME = r'^[a-zA-Z \'\-]*$'


class DocumentType(Enum):
    ru_national_passport = 'ru_national_passport'
    ru_foreign_passport = 'ru_foreign_passport'
    ru_birth_certificate = 'ru_birth_certificate'
    ru_seaman_passport = 'ru_seaman_passport'
    ru_military_id = 'ru_military_id'
    other = 'other'


DOCUMENT_SETTINGS = {
    DocumentType.ru_national_passport: ValidationSettings(
        required=['number', 'citizenship'],
        unused=['expiration_date', 'citizenship'],
        re_validations={
            'number': r'^\d{10}$',
            'first_name': REGEXP_RU_NAME,
            'middle_name': REGEXP_RU_NAME,
            'last_name': REGEXP_RU_NAME,
            'first_name_en': REGEXP_EN_NAME,
            'middle_name_en': REGEXP_EN_NAME,
            'last_name_en': REGEXP_EN_NAME,
        },
    ),
    DocumentType.ru_birth_certificate: ValidationSettings(
        required=['number', 'citizenship'],
        unused=['expiration_date', 'citizenship'],
        re_validations={
            'number': r'^[IVXivx]+[а-яёА-ЯЁ]{2}\d{6}$',
            'first_name': REGEXP_RU_NAME,
            'middle_name': REGEXP_RU_NAME,
            'last_name': REGEXP_RU_NAME,
            'first_name_en': REGEXP_EN_NAME,
            'middle_name_en': REGEXP_EN_NAME,
            'last_name_en': REGEXP_EN_NAME,
        },
    ),
    DocumentType.ru_foreign_passport: ValidationSettings(
        required=['number', 'citizenship'],
        unused=['citizenship'],
        re_validations={
            'number': r'^\d{9}$',
            'first_name_en': REGEXP_EN_NAME,
            'middle_name_en': REGEXP_EN_NAME,
            'last_name_en': REGEXP_EN_NAME,
        },
    ),
    DocumentType.ru_military_id: ValidationSettings(
        required=['number', 'first_name', 'last_name', 'citizenship'],
        unused=['expiration_date', 'citizenship', 'first_name_en', 'middle_name_en', 'last_name_en'],
        re_validations={
            'number': r'^[а-яёА-ЯЁ]{2}\d{7}$',
            'first_name': REGEXP_RU_NAME,
            'middle_name': REGEXP_RU_NAME,
            'last_name': REGEXP_RU_NAME,
        },
    ),
    DocumentType.ru_seaman_passport: ValidationSettings(
        required=['number', 'first_name', 'last_name', 'citizenship'],
        unused=['expiration_date', 'citizenship', 'first_name_en', 'middle_name_en', 'last_name_en'],
        re_validations={
            'number': r'^[IVXivx]{2}\d{7}$',
            'first_name': REGEXP_RU_NAME,
            'middle_name': REGEXP_RU_NAME,
            'last_name': REGEXP_RU_NAME,
        },
    ),
    DocumentType.other: ValidationSettings(
        required=['number', 'citizenship'],
        unused=[],
        re_validations={
            'first_name': REGEXP_RU_NAME,
            'middle_name': REGEXP_RU_NAME,
            'last_name': REGEXP_RU_NAME,
            'first_name_en': REGEXP_EN_NAME,
            'middle_name_en': REGEXP_EN_NAME,
            'last_name_en': REGEXP_EN_NAME,
        },
    ),
}
