# -*- encoding: utf-8 -*-
import logging
import time
from typing import Optional

from tornado.escape import json_encode


def yt_request_log(
    service_id: int,
    method: str,
    uid: str,
    traveler_id: Optional[str] = None,
    passenger_id: Optional[str] = None,
    document_id: Optional[str] = None,
    bonus_card_id: Optional[str] = None,
):
    logging.getLogger('yt.request').info(
        json_encode(
            {
                'unixtime': int(time.time()),
                'service_id': service_id,
                'method': method,
                'uid': str(uid),
                'traveler_id': str(traveler_id),
                'passenger_id': str(passenger_id) if passenger_id else None,
                'document_id': str(document_id) if document_id else None,
                'bonus_card_id': str(bonus_card_id) if bonus_card_id else None,
            }
        )
    )
