# -*- encoding: utf-8 -*-
import logging

import tornado
import tornado.process
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
from tornado.netutil import bind_unix_socket
from tornado.options import define, options

from travel.avia.travelers.application import create_application
from travel.avia.library.python.shared_objects import SharedFlag
from travel.avia.travelers.application.settings import SOCKET_PATH, WORKERS, setup_logging

logger = logging.getLogger()

define('debug', default=False, help='Debug mode')


def main():
    setup_logging()

    sockets = [
        bind_unix_socket(SOCKET_PATH, 0o666)
    ]

    shutdown_flag = SharedFlag()
    if WORKERS == 1:
        application = create_application(shutdown_flag=shutdown_flag, debug=options.debug)
        server = HTTPServer(application)
        server.add_sockets(sockets)
        server.start(1)
    else:
        tornado.process.fork_processes(WORKERS)
        application = create_application(shutdown_flag=shutdown_flag, debug=options.debug)
        server = HTTPServer(application)
        server.add_sockets(sockets)

    IOLoop.current().start()


if __name__ == '__main__':
    options.parse_command_line()
    logger.info('Tornado version: {}'.format(tornado.version))
    logger.info('Debug: {}'.format(options.debug))

    main()
