#!/usr/bin/env bash

set -e

mkdir -p /ephemeral/var/log/yandex-avia-travelers/yt
touch /ephemeral/var/log/yandex-avia-travelers/yt/request.log

/etc/yandex/statbox-push-client/pre_start.sh

# настройка tvm-авторизации
envsubst '${AVIA_TRAVELERS_TVM_SERVICE_ID} ${AVIA_FRONTEND_TVM_SERVICE_ID} ${TRAINS_FRONTEND_TVM_SERVICE_ID} ${TRAVEL_PORTAL_TVM_SERVICE_ID} ${SUBURBAN_BACKEND_TVM_SERVICE_ID} ${TRAVEL_APP_BACKEND_TVM_SERVICE_ID}' \
    < /app/docker/nginx/sites-enabled/default > /tmp/temp.conf
mv /tmp/temp.conf /etc/nginx/sites-enabled/default

/etc/nginx/pre_start.sh

if [ -n ${DEPLOY_NODE_DC} ]; then
    CURRENT_DC=${DEPLOY_NODE_DC,,} /usr/bin/supervisord -c /etc/supervisor/supervisord.conf
else
    /usr/bin/supervisord -c /etc/supervisor/supervisord.conf
fi
