# coding: utf8
from base_util import nginx_log_normalize_uri

# Если в регулярке есть исключающие символы, заводим как кортеж, иначе просто как строку
paths = [
    (r'keys$', None),

    (r'document_types$', '/document_types'),

    (r'travelers/\d+$', '/travelers/ID'),

    (r'travelers/\d+/passengers$', '/travelers/ID/passengers'),
    (r'travelers/\d+/passengers/[^\/]+$', '/travelers/ID/passengers/<id>'),
    (r'travelers/\d+/passengers/[^\/]+/combine$', '/travelers/ID/passengers/ID/combine'),

    (r'travelers/\d+/passengers/[^\/]+/documents$', '/travelers/ID/passengers/ID/documents'),
    (r'travelers/\d+/passengers/[^\/]+/documents/[^\/]+$', '/travelers/ID/passengers/ID/documents/ID'),

    (r'travelers/\d+/passengers/[^\/]+/bonus-cards$', '/travelers/ID/passengers/ID/bonus-cards'),
    (r'travelers/\d+/passengers/[^\/]+/bonus-cards/[^\/]+$', '/travelers/ID/passengers/ID/bonus-cards/ID'),
]


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(paths, uri)
