PY3_LIBRARY(travelers)

OWNER(g:avia)

PEERDIR(
    contrib/python/marshmallow/py3
    contrib/python/marshmallow-enum
    contrib/python/raven
    contrib/python/retrying
    contrib/python/requests
    contrib/python/tornado/tornado-4
    library/python/deprecated/ticket_parser2

    travel/library/python/cloud_logger
    travel/library/python/tvm_ticket_provider
    travel/library/python/tracing/tornado_opentracing_helpers

    travel/avia/library/python/error_booster/raven
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/http_geobase
    travel/avia/library/python/shared_objects
)

PY_SRCS(
    application/__init__.py
    application/handlers/__init__.py
    application/handlers/bonus_cards.py
    application/handlers/combine_passengers.py
    application/handlers/document_types.py
    application/handlers/documents.py
    application/handlers/passengers.py
    application/handlers/traveler.py
    application/lib/__init__.py
    application/lib/feature_flag_storage.py
    application/models.py
    application/schemas.py
    application/services/__init__.py
    application/services/data_sync/__init__.py
    application/services/data_sync/client.py
    application/services/data_sync/schemas.py
    application/services/geodata/__init__.py
    application/services/geodata/client.py
    application/settings.py
    application/validations/__init__.py
    application/validations/bonus_card_types/__init__.py
    application/validations/document_types/__init__.py
    application/yt_logging.py
)

END()

RECURSE(
    bin
    tests
)

RECURSE_FOR_TESTS(
    tests
)
