package app

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/database"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/pgclient"
	"golang.yandex/hasql"
)

func BuildPGClient(
	logger log.Logger,
) (*pgclient.PGClient, error) {
	return pgclient.NewPGClient(
		Cfg.Database.Hosts,
		Cfg.Database.Port,
		Cfg.Database.Name,
		Cfg.Database.User,
		Cfg.Database.Password,
		pgclient.DefaultInitTimeout,
		append(
			pgclient.DefaultClusterOptions, hasql.WithUpdateTimeout(Cfg.Database.HostsUpdateTimeout), hasql.WithTracer(
				hasql.Tracer{
					NodeDead: database.OnDeadNode(logger),
				},
			),
		),
	)
}
