package app

import (
	"a.yandex-team.ru/travel/avia/weekendtour/internal/database"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/readers/ytreader"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
)

type Config struct {
	EnvType  string `config:"YANDEX_ENVIRONMENT_TYPE,required" yaml:"yandex_environment_type"`
	HTTP     httpserver.HTTPConfig
	Grpc     grpcserver.GrpcConfig
	Metrics  metricsserver.MetricsConfig
	Logging  logging.Config
	Database database.Config
	YTReader ytreader.Config
	YavToken string `config:"YAV_TOKEN" yaml:"yav_token"`
}

func (c Config) IsDevelopment() bool {
	return c.EnvType == "development"
}

func (c Config) IsTesting() bool {
	return c.EnvType == "testing"
}

var Cfg = Config{
	HTTP:     httpserver.DefaultHTTPConfig,
	Grpc:     grpcserver.DefaultGrpcConfig,
	Metrics:  metricsserver.DefaultMetricsConfig,
	Logging:  logging.DefaultConfig,
	Database: database.DefaultConfig,
	YTReader: ytreader.DefaultConfig,
}
