package cron

import (
	"context"

	"github.com/jasonlvhit/gocron"
)

// TODO(u-jeen): move this code from Notifier project to a common avia or travel library
// https://st.yandex-team.ru/RASPTICKETS-20959
type Scheduler struct {
	*gocron.Scheduler
	context context.Context
	stopper chan bool
}

func NewScheduler(ctx context.Context, scheduler *gocron.Scheduler) *Scheduler {
	s := &Scheduler{Scheduler: scheduler, context: ctx}
	go s.waitContextCancellation()
	return s
}

func (s *Scheduler) waitContextCancellation() {
	<-s.context.Done()
	if s.stopper != nil {
		s.stopper <- true
	}
}

func (s *Scheduler) Start() {
	s.stopper = s.Scheduler.Start()
}
