package models

import (
	"fmt"

	"a.yandex-team.ru/travel/avia/weekendtour/internal/pgclient"
)

func MigrateAndInit(pgClient *pgclient.PGClient) error {
	if err := autoMigrateAll(pgClient); err != nil {
		return err
	}
	return nil
}

func DropAll(pgClient *pgclient.PGClient) error {
	rwDB, err := pgClient.GetPrimary()
	if err != nil {
		return errDrop{err}
	}

	err = rwDB.Migrator().DropTable(
		&RoundTrip{},
		&WeekendTour{},
	)
	if err != nil {
		return errDrop{err}
	}

	return nil
}

func autoMigrateAll(pgClient *pgclient.PGClient) error {
	rwDB, err := pgClient.GetPrimary()
	if err != nil {
		return errMigrateModels{err}
	}

	err = rwDB.AutoMigrate(
		&RoundTrip{},
		&WeekendTour{},
	)
	if err != nil {
		return errMigrateModels{err}
	}
	return nil
}

type errMigrateModels struct {
	err error
}

func (e errMigrateModels) Error() string {
	return fmt.Sprintf("failed to automigrate database models: %s", e.err)
}

type errDrop struct {
	err error
}

func (e errDrop) Error() string {
	return fmt.Sprintf("failed to drop db: %s", e.err)
}
