package models

import (
	pb "a.yandex-team.ru/travel/avia/weekendtour/api/v1"
)

type WeekendTourRequest struct {
	PointFromKey string // Origin of the journey
	WeekendID    int32  // Friday of the weekend, e.g. 20210702
}

type WeekendTourResponse struct {
	Entries []WeekendTour `json:"entries"`
}

func NewWeekendTourRequestFromProto(req *pb.TWeekendTourReq) WeekendTourRequest {
	return WeekendTourRequest{
		PointFromKey: req.PointFromKey,
		WeekendID:    req.WeekendId,
	}
}

func NewWeekendTourRequest(pointFromKey string, weekendID int32) WeekendTourRequest {
	return WeekendTourRequest{
		PointFromKey: pointFromKey,
		WeekendID:    weekendID,
	}
}

func (r *WeekendTourResponse) ToProto() *pb.TWeekendTourRsp {
	pbEntries := []*pb.TWeekendTour{}
	for _, e := range r.Entries {
		pbEntries = append(pbEntries, e.ToProto())
	}
	return &pb.TWeekendTourRsp{
		Entries: pbEntries,
	}
}

func (t *WeekendTour) ToProto() *pb.TWeekendTour {
	return &pb.TWeekendTour{
		PointFromKey: t.PointFromKey,
		PointToKey:   t.PointToKey,
		Price:        t.Price,
	}
}
