package models

type WeekendTour struct {
	ID           uint    `gorm:"primaryKey" json:"-"`
	PointFromKey string  `gorm:"not null;index:from_to_week" json:"point_from_key"`
	PointToKey   string  `gorm:"not null;index:from_to_week" json:"point_to_key"`
	WeekendID    uint    `gorm:"not null;index:from_to_week" json:"weekend"`
	Price        float64 `gorm:"not null" json:"price"`
}

type RoundTrip struct {
	ID              uint    `gorm:"primaryKey" json:"-"`
	PointFromKey    string  `gorm:"not null;index:round_trip_week" json:"point_from_key"`
	PointToKey      string  `gorm:"not null;index:round_trip_week" json:"point_to_key"`
	WeekendID       uint    `gorm:"not null;index:round_trip_week" json:"weekend_id"`
	ForwardFlights  string  `gorm:"not null;uniqueIndex:flights_and_price" json:"forward_flights"`
	BackwardFlights string  `gorm:"not null;uniqueIndex:flights_and_price" json:"backward_flights"`
	Currency        string  `gorm:"not null;uniqueIndex:flights_and_price" json:"currency"`
	Price           float64 `gorm:"not null;uniqueIndex:flights_and_price" json:"price"`
}
