package pgclient

import (
	"database/sql"
	"time"

	"golang.yandex/hasql"
)

type Option func(*sql.DB)

// pool setting per DB host
func MaxIdlePoolConns(conns int) Option {
	return func(db *sql.DB) {
		db.SetMaxIdleConns(conns)
	}
}

// pool setting per DB host
func MaxOpenPoolConns(conns int) Option {
	return func(db *sql.DB) {
		db.SetMaxOpenConns(conns)
	}
}

// pool setting per DB host
func PoolConnMaxLifetime(lifetime time.Duration) Option {
	return func(db *sql.DB) {
		db.SetConnMaxLifetime(lifetime)
	}
}

var defaultPoolOptions = []Option{MaxOpenPoolConns(100)}

var DefaultClusterOptions = []hasql.ClusterOption{
	hasql.WithUpdateInterval(2 * time.Second),
	hasql.WithNodePicker(hasql.PickNodeClosest()),
}

var DefaultInitTimeout = 60 * time.Second
