package pgclient

import (
	"context"
	"database/sql"
	"golang.yandex/hasql"
	"golang.yandex/hasql/checkers"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
)

func gormWrapper(node hasql.Node) (*gorm.DB, error) {
	return gorm.Open(
		postgres.New(
			postgres.Config{
				Conn: node.DB(),
			},
		), &gorm.Config{},
	)
}

func (c *PGClient) nodeChecker(ctx context.Context, db *sql.DB) (bool, error) {
	isPrimary, err := checkers.Check(ctx, db, "SELECT NOT pg_is_in_recovery()")
	return isPrimary, err
}
