package filters

import (
	"strings"
	"time"

	"a.yandex-team.ru/travel/avia/weekendtour/internal/models"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/readers/ytreader"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/service/utils"
)

type RoundTripFilter struct {
}

func NewRoundTripFilter() *RoundTripFilter {
	return &RoundTripFilter{}
}

func (f *RoundTripFilter) FilterName() string {
	return "roundTrip"
}

func (f *RoundTripFilter) AcceptsQID(qid string) bool {
	// "210501-040258-682.mavia-travel.plane.c65_c239_2021-05-09_2021-05-15_economy_1_0_0_ru.ru"
	return strings.HasSuffix(qid, "_1_0_0_ru.ru")
}

func (f *RoundTripFilter) AcceptsJourney(journey ytreader.JourneyBoundaries) bool {
	return journey.ReturnDate != ""

}

func (f *RoundTripFilter) AcceptsVariant(roundTrip models.RoundTrip) bool {
	if roundTrip.Currency != "RUB" {
		return false
	}
	departureWeekday, err := utils.GetWeekdayForFlight(utils.GetFirstFlight(roundTrip.ForwardFlights))
	if err != nil || departureWeekday != time.Friday {
		return false
	}
	returnWeekday, err := utils.GetWeekdayForFlight(utils.GetFirstFlight(roundTrip.BackwardFlights))
	if err != nil || returnWeekday != time.Sunday {
		return false
	}
	return true
}
