package metrics

import "a.yandex-team.ru/travel/library/go/metrics"

const metricPrefix = "weekendtour"

type TourType int

const (
	TourTypeUnknown TourType = iota
	TourTypeAvia
	TourTypeRail
)

var metricNames = map[TourType]string{
	TourTypeUnknown: "unknown",
	TourTypeAvia:    "avia",
	TourTypeRail:    "rail",
}

func WriteWeekendTourMetric(ttype TourType) {
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		metricPrefix,
		nil,
		metricNames[TourTypeAvia],
	).Inc()
}
