package polling

import (
	"context"

	"github.com/jasonlvhit/gocron"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/cron"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/readers/ytreader"
	"a.yandex-team.ru/travel/library/go/vault"
)

type FlightVariantsPollingService struct {
	config   ytreader.Config
	resolver *vault.YavSecretsResolver
	consumer ytreader.VariantsConsumer
	logger   log.Logger
}

func NewFlightVariantsPollingService(
	config ytreader.Config,
	resolver *vault.YavSecretsResolver,
	consumer ytreader.VariantsConsumer,
	logger log.Logger,
) *FlightVariantsPollingService {
	return &FlightVariantsPollingService{
		config:   config,
		resolver: resolver,
		consumer: consumer,
		logger:   logger,
	}
}

func (s *FlightVariantsPollingService) Start(ctx context.Context) error {
	ytReader, err := ytreader.NewYTReader(s.config, s.resolver, s.logger)
	if err != nil {
		return err
	}
	cronScheduler := cron.NewScheduler(ctx, gocron.NewScheduler())
	if s.config.PollingInterval > 0 {
		singleRun := func() {
			s.logger.Infof("started polling the latest variants table")
			err := ytReader.ReadLatestTable(ctx, s.consumer)
			if err != nil {
				s.logger.Errorf("error while polling ticket-daemon variants logs: %+v", err)
			}
		}
		cronScheduler.Every(uint64(s.config.PollingInterval)).Minutes().Do(singleRun)
		go singleRun()
	}
	cronScheduler.Start()
	return nil
}
