package tours

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/models"
	"a.yandex-team.ru/travel/avia/weekendtour/internal/service/metrics"
	"context"
)

type Service struct {
	logger log.Logger
}

func (s *Service) GetTours(ctx context.Context, request models.WeekendTourRequest) (response models.WeekendTourResponse, err error) {
	s.logger.Debugf("WeekendTourService.GetTours called %+v", request)
	metrics.WriteWeekendTourMetric(metrics.TourTypeAvia)
	return
}

func NewService(l log.Logger) *Service {
	return &Service{logger: l}
}
