package utils

import (
	"fmt"
	"strconv"
	"time"
)

func GetDepartureDateForFlight(flight string) (time.Time, error) {
	strlen := len(flight)
	if strlen < 20 {
		return time.Time{}, fmt.Errorf("string to decipher a flight is too short: %v", flight)
	}
	year2digits, err := strconv.Atoi(flight[0:2])
	if err != nil {
		return time.Time{}, err
	}
	departureYear := 2000 + year2digits
	departureMonth, err := strconv.Atoi(flight[2:4])
	if err != nil {
		return time.Time{}, err
	}
	departureDay, err := strconv.Atoi(flight[4:6])
	if err != nil {
		return time.Time{}, err
	}
	// 00:30 time is randomly selected, all we need is a weekday anyway
	return time.Date(departureYear, time.Month(departureMonth), departureDay, 0, 30, 0, 0, time.UTC), nil
}

func GetWeekdayForFlight(flight string) (time.Weekday, error) {
	departureDate, err := GetDepartureDateForFlight(flight)
	if err != nil {
		return time.Monday, err
	}
	return departureDate.Weekday(), nil
}

func GetWeekendID(flights string) (uint, error) {
	result, err := GetWeekendIDForFlight(GetFirstFlight(flights))
	return result, err
}

func GetWeekendIDForFlight(flight string) (uint, error) {
	departureDate, err := GetDepartureDateForFlight(flight)
	if err != nil {
		return 0, err
	}
	return GetWeekendIDForDate(departureDate), nil
}

func GetWeekendIDForDate(departureDate time.Time) uint {
	daysShift := 0
	switch departureDate.Weekday() {
	case time.Monday:
		daysShift = 4
	case time.Tuesday:
		daysShift = 3
	case time.Wednesday:
		daysShift = 2
	case time.Thursday:
		daysShift = 1
	case time.Friday:
		daysShift = 0
	case time.Saturday:
		daysShift = -1
	case time.Sunday:
		daysShift = -2
	}
	departureFriday := departureDate.AddDate(0, 0, daysShift)
	return uint((departureFriday.Year()*100+int(departureFriday.Month()))*100 + departureFriday.Day())
}
