package main

import (
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/caches/references"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/repositories"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
)

type applicationRepositories struct {
	companyRepository             repositories.Company
	stationRepository             repositories.Station
	settlementRepository          repositories.Settlement
	regionRepository              repositories.Region
	settlementTimeZoneRepository  repositories.SettlementTimeZone
	stationToSettlementRepository repositories.StationToSettlement
	popularSettlementsRepository  repositories.PopularSettlements
	nameSearchIndex               repositories.NameSearchIndex
	bannedFlightRepository        repositories.BannedFlight
	translatedTitleRepository     repositories.TranslatedTitle
	resultsRepository             repositories.ResultsRepository
	partnerRepository             repositories.Partner
	companyTariffRepository       repositories.CompanyTariff
	aviaCompanyRepository         repositories.AviaCompany
	directionRepository           repositories.Direction
	countryRepository             repositories.Country
	minPriceRepository            repositories.MinPrices
	currencyRepository            repositories.Currency
	routeCountRepository          repositories.RouteCount
	locationRepository            repositories.CachedLocation
	checkedBaggageRepository      repositories.CachedCheckedBaggage
	conversionRepository          repositories.ConversionRepository
}

func buildRepositories(
	refs *references.ResourceRegistry,
	appSettings *settings.Settings,
	appLogger log.Logger,
	ydbSessionPool *table.SessionPool,
	partnerReference *references.Partners,
) *applicationRepositories {
	appRepositories := applicationRepositories{}

	appRepositories.checkedBaggageRepository = repositories.NewCachedBaggageCodeRepository()
	appRepositories.locationRepository = repositories.NewCachedLocationRepository()
	appRepositories.companyRepository = repositories.NewCompanyRepository(refs.AviaCompany, refs.Company)
	appRepositories.currencyRepository = repositories.NewCurrencyRepository(refs.Currency)
	appRepositories.stationRepository = repositories.NewStationRepository(refs.StationCode, refs.Station, refs.CodeSystem)
	appRepositories.settlementRepository = repositories.NewSettlementRepository(
		appRepositories.stationRepository, refs.StationToSettlement, refs.Settlements)
	appRepositories.regionRepository = repositories.NewRegionRepository(refs.Region)
	appRepositories.countryRepository = repositories.NewCountryRepository(refs.Country)
	appRepositories.settlementTimeZoneRepository = repositories.NewSettlementTimeZoneRepository(
		appRepositories.settlementRepository)
	appRepositories.stationToSettlementRepository = repositories.NewStationToSettlementRepository(
		appRepositories.settlementRepository, refs.StationToSettlement)
	appRepositories.popularSettlementsRepository = repositories.NewPopularSettlementsRepository(
		refs.SettlementPopularities, refs.Settlements)
	appRepositories.translatedTitleRepository = repositories.NewTranslatedTitleRepository(
		refs.TranslatedTitle,
		appSettings.LanguageFallbacks,
		appSettings.LanguageCaseFallbacks,
	)
	appRepositories.companyTariffRepository = repositories.NewCompanyTariffRepository(refs.CompanyTariff)
	appRepositories.aviaCompanyRepository = repositories.NewAviaCompanyRepository(refs.AviaCompany)

	appRepositories.nameSearchIndex = repositories.NewNameSearchIndex(
		refs.PointSynonym, appRepositories.translatedTitleRepository, appRepositories.countryRepository,
		appRepositories.settlementRepository, appRepositories.stationRepository, appRepositories.regionRepository,
	)
	appRepositories.bannedFlightRepository = repositories.NewBannedFlightRepository(appSettings, appLogger)
	appRepositories.resultsRepository = repositories.NewYDBResultsRepository(
		appLogger,
		ydbSessionPool,
		appSettings.YdbSettings,
		appSettings.Search,
	)
	appRepositories.partnerRepository = repositories.NewPartnerRepository(partnerReference, appSettings.References.RecachePartnersInterval)
	appRepositories.directionRepository = repositories.NewDirectionRepository(refs.Direction)
	appRepositories.minPriceRepository = refs.MinPrice     // TODO: Create a real repository instead of the life-hack with reference
	appRepositories.routeCountRepository = refs.RouteCount // TODO: Create a real repository instead of the life-hack with reference
	appRepositories.conversionRepository = *repositories.NewConversionRepository(appLogger, appSettings.Conversion, appRepositories.partnerRepository, refs)
	return &appRepositories
}
