package main

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/translations"
)

type applicationTranslators struct {
	flight       *translations.FlightTranslator
	time         *translations.TimeTranslator
	common       *translations.CommonTranslator
	pointToPoint *translations.PointToPointTranslator
}

func buildTranslators(
	appSettings *settings.Settings,
	appLogger log.Logger,
	appRepositories *applicationRepositories,
) *applicationTranslators {
	pointDeclinatorFactory := translations.NewPointDeclinatorFactory(appRepositories.translatedTitleRepository)
	tankerTranslator := translations.GetTranslator(appSettings, appLogger)
	timeTranslator := translations.NewTimeTranslator(tankerTranslator, appLogger)
	commonTranslator := translations.NewCommonTranslator(tankerTranslator, appLogger, pointDeclinatorFactory)
	flightTranslator := translations.NewFlightTranslator(
		tankerTranslator, appRepositories.translatedTitleRepository, appLogger, timeTranslator)
	pointToPointTranslator := translations.NewPointToPointTranslator(tankerTranslator, appLogger, pointDeclinatorFactory)

	return &applicationTranslators{
		flight:       flightTranslator,
		time:         timeTranslator,
		common:       commonTranslator,
		pointToPoint: pointToPointTranslator,
	}
}
