package main

import (
	"fmt"
	"runtime/debug"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/settings"
	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/tracing"
)

func main() {
	app := newApplication(settings.NewSettings())
	loggersCloser := app.configureLogging()
	defer loggersCloser()

	tracerCloser := tracing.ConfigureTracer(app.logger)
	defer tracerCloser.Close()

	maxprocs.AdjustAuto()
	debug.SetGCPercent(app.settings.GOGC)
	app.logger.Info(fmt.Sprintf("Starting app with GOGC: %d", app.settings.GOGC))

	ydbSessionPoolCloser := app.configureYDBSessionPool()
	defer ydbSessionPoolCloser()
	app.configureHTTPClient()
	app.configureReferences()
	destroyGeobase := app.configureGeobase()
	defer destroyGeobase()
	app.configureRepositories()
	app.configureQueryParameterParser()
	err := app.configureClients()
	if err != nil {
		app.logger.Fatal("failed to configure clients", log.Error(err))
	}
	app.configureTranslators()

	app.configureServer()
	app.runDynamicResourcesService()
	app.run()
}
