package geobase

import (
	"fmt"

	"a.yandex-team.ru/library/go/yandex/geobase"
)

type Config struct {
	Datafile string `config:"AVIA_WIZARD_GEOBASE_PATH"`
	Enabled  bool   `config:"AVIA_WIZARD_GEOBASE_ENABLED"`
}

var DefaultConfig = Config{
	Datafile: "",
	Enabled:  false,
}

func NewGeobase(config *Config) (geobase.Geobase, error) {
	g, err := geobase.New(
		geobase.WithDatafilePath(config.Datafile),
	)
	if err != nil {
		return nil, fmt.Errorf("cannot init geobase: %v", err)
	}
	return g, nil
}
