package tanker

import (
	"encoding/json"
	"os"

	"a.yandex-team.ru/travel/library/go/tanker"
)

type KeysetFileSaver struct {
	outputFile string
}

func NewKeysetFileSaver(outputFile string) *KeysetFileSaver {
	return &KeysetFileSaver{outputFile: outputFile}
}

func (keysetFileSaver *KeysetFileSaver) Save(keyset tanker.Keyset) (err error) {
	writer, err := os.OpenFile(keysetFileSaver.outputFile, os.O_WRONLY|os.O_APPEND|os.O_CREATE, 0644)
	if writer != nil {
		defer writer.Close()
	}
	if err != nil {
		return err
	}
	stdoutEncoder := json.NewEncoder(writer)
	stdoutEncoder.SetEscapeHTML(false)
	stdoutEncoder.SetIndent("", "    ")
	err = stdoutEncoder.Encode(keyset)
	return err
}
