package tanker

import (
	"encoding/json"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/tanker"
)

func ReadWizardKeyset(keysetFilePath string, logger log.Logger) (keyset tanker.Keyset, err error) {
	keysetFile, err := os.Open(keysetFilePath)
	if keysetFile != nil {
		defer keysetFile.Close()
	}
	if err != nil {
		logger.Error(fmt.Sprintf("couldn't read tanker keyset from file %s. Error: %+v", keysetFilePath, err))
		return nil, err
	}
	err = json.NewDecoder(keysetFile).Decode(&keyset)
	if err != nil {
		logger.Error(fmt.Sprintf("couldn't decode keyset json from file %s. Error: %+v", keysetFilePath, err))
	}
	return keyset, err
}
