package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type idToCityMajority map[int]*models.CityMajority

type CityMajority struct {
	idToCityMajority idToCityMajority
}

func NewCityMajority() *CityMajority {
	return &CityMajority{
		idToCityMajority: make(idToCityMajority),
	}
}

func (reference *CityMajority) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCityMajority()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*reference = *newState
	return nil
}

func (reference *CityMajority) Write(b []byte) (int, error) {
	message := new(dictsproto.TCityMajority)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("CityMajority:Write: %w", err)
	}
	model := reference.convertProtoReferenceToModel(message)
	reference.idToCityMajority[model.ID] = model
	return len(b), nil
}

func (reference *CityMajority) convertProtoReferenceToModel(proto *dictsproto.TCityMajority) *models.CityMajority {
	model := new(models.CityMajority)
	model.ID = int(proto.Id)
	model.Title = proto.Title
	return model
}
