package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type idToCodeSystem map[int]*models.CodeSystem

type CodeSystem struct {
	idToCodeSystem idToCodeSystem
}

func NewCodeSystem() *CodeSystem {
	return &CodeSystem{
		idToCodeSystem: make(idToCodeSystem),
	}
}

func (ref *CodeSystem) GetByID(id int) (*models.CodeSystem, bool) {
	codeSystem, found := ref.idToCodeSystem[id]
	return codeSystem, found
}

func (ref *CodeSystem) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCodeSystem()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *CodeSystem) Write(b []byte) (int, error) {
	message := new(dictsproto.TCodeSystem)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("CodeSystem:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.idToCodeSystem[model.ID] = model
	return len(b), nil
}

func (ref *CodeSystem) convertProtoReferenceToModel(proto *dictsproto.TCodeSystem) *models.CodeSystem {
	reference := new(models.CodeSystem)
	reference.ID = int(proto.Id)
	reference.Title = proto.Title
	reference.Code = proto.Code
	return reference
}
