package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type companies []*models.Company

type Company struct {
	companies companies
}

func NewCompany() *Company {
	return &Company{
		companies: make(companies, 0),
	}
}

func (ref *Company) GetAll() []*models.Company {
	return ref.companies
}

func (ref *Company) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCompany()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Company) Write(b []byte) (int, error) {
	message := new(dictsproto.TCompany)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Company:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.companies = append(ref.companies, model)
	return len(b), nil
}

func (ref *Company) convertProtoReferenceToModel(proto *dictsproto.TCompany) *models.Company {
	return &models.Company{
		ID:          int(proto.Id),
		Iata:        proto.Iata,
		SirenaID:    proto.SirenaID,
		Title:       proto.Title,
		TitleEn:     proto.TitleEn,
		TitleRu:     proto.TitleRu,
		TitleTr:     proto.TitleTr,
		TitleUk:     proto.TitleUk,
		Slug:        proto.Slug,
		SvgLogo2:    proto.SvgLogo2,
		NewLTitleID: int(proto.NewLTitleID),
	}
}
