package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type CompanyTariff struct {
	companyTariffs []*models.CompanyTariff
}

func NewCompanyTariff() *CompanyTariff {
	return &CompanyTariff{}
}

func (ref *CompanyTariff) GetAll() []*models.CompanyTariff {
	return ref.companyTariffs
}

func (ref *CompanyTariff) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCompanyTariff()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *CompanyTariff) Write(b []byte) (int, error) {
	message := new(dictsproto.TCompanyTariff)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("CompanyTariff:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.companyTariffs = append(ref.companyTariffs, model)
	return len(b), nil
}

func (ref *CompanyTariff) convertProtoReferenceToModel(proto *dictsproto.TCompanyTariff) *models.CompanyTariff {
	reference := new(models.CompanyTariff)
	reference.ID = int(proto.Id)
	reference.AviaCompanyID = int(proto.AviaCompanyId)
	reference.BaggageAllowed = int(proto.BaggageAllowed)
	reference.CarryOn = int(proto.Carryon)
	reference.CarryOnNorm = proto.CarryonNorm
	reference.Published = proto.Published > 0
	return reference
}
