package references

import (
	"compress/zlib"
	"io/ioutil"
	"os"
	"runtime"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type Conversion struct {
	conversions []*models.Conversion
}

func NewConversion() *Conversion {
	return &Conversion{
		conversions: make([]*models.Conversion, 0),
	}
}

func (ref *Conversion) GetAll() []*models.Conversion {
	return ref.conversions
}

func (ref *Conversion) UpdateFromFile(resourcePath string) error {
	file, err := os.Open(resourcePath + "/partner_conversions.data")
	if err != nil {
		return err
	}
	defer file.Close()
	zlibReader, err := zlib.NewReader(file)
	if err != nil {
		return err
	}
	protoBytes, err := ioutil.ReadAll(zlibReader)
	if err != nil {
		return err
	}

	conversions := make([]*models.Conversion, 0)
	conversionsProto := dictsproto.TConversions{}
	if err := proto.Unmarshal(protoBytes, &conversionsProto); err != nil {
		return err
	}
	for _, conversionProto := range conversionsProto.Conversions {
		runtime.Gosched()
		conversions = append(
			conversions, &models.Conversion{
				BillingOrderID: int(conversionProto.BillingOrderID),
				Conversion:     conversionProto.Conversion,
				Source:         conversionProto.Source,
			},
		)
	}
	ref.conversions = conversions
	return nil
}
