package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type Country struct {
	countries []*models.Country
}

func NewCountry() *Country {
	return &Country{
		countries: make([]*models.Country, 0),
	}
}

func (ref *Country) GetAll() []*models.Country {
	return ref.countries
}

func (ref *Country) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCountry()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Country) Write(b []byte) (int, error) {
	message := new(dictsproto.TCountry)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Country:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.countries = append(ref.countries, model)
	return len(b), nil
}

func (ref *Country) convertProtoReferenceToModel(proto *dictsproto.TCountry) *models.Country {
	reference := new(models.Country)
	reference.ID = int(proto.Id)
	reference.Title = proto.Title
	reference.GeoID = int(proto.GeoId)
	reference.NewLTitleID = int(proto.NewLTitleID)
	return reference
}
