package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type Currency struct {
	currencies []*models.Currency
}

func NewCurrency() *Currency {
	return &Currency{
		currencies: make([]*models.Currency, 0),
	}
}

func (ref *Currency) GetAll() []*models.Currency {
	return ref.currencies
}

func (ref *Currency) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCurrency()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Currency) Write(b []byte) (int, error) {
	message := new(dictsproto.TCurrency)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Currency:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.currencies = append(ref.currencies, model)
	return len(b), nil
}

func (ref *Currency) convertProtoReferenceToModel(proto *dictsproto.TCurrency) *models.Currency {
	reference := new(models.Currency)
	reference.ID = int(proto.Id)
	reference.Title = proto.Title
	reference.Code = proto.Code
	reference.IsoCode = proto.IsoCode
	reference.Priority = int(proto.Priority)
	reference.Enable = int(proto.Enable)
	return reference
}
