package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/avia/wizard"
)

type Direction struct {
	directions []*models.Direction
}

func NewDirection() *Direction {
	return &Direction{}
}

func (ref *Direction) GetAll() []*models.Direction {
	return ref.directions
}

func (ref *Direction) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewDirection()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Direction) Write(b []byte) (int, error) {
	message := new(dictsproto.TDirectionNational)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Direction:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.directions = append(ref.directions, model)
	return len(b), nil
}

func (ref *Direction) convertProtoReferenceToModel(proto *dictsproto.TDirectionNational) *models.Direction {
	reference := new(models.Direction)
	reference.ID = int(proto.ID)
	reference.DepartureSettlementID = int(proto.DepartureSettlementID)
	reference.ArrivalSettlementID = int(proto.ArrivalSettlementID)
	reference.Popularity = int(proto.Popularity)
	reference.NationalVersion = proto.NationalVersion
	return reference
}
