package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type idToIataCorrection map[int]*models.IataCorrection

type IataCorrection struct {
	idToIataCorrection idToIataCorrection
}

func NewIataCorrection() *IataCorrection {
	return &IataCorrection{
		idToIataCorrection: make(idToIataCorrection),
	}
}

func (ref *IataCorrection) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewIataCorrection()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *IataCorrection) Write(b []byte) (int, error) {
	message := new(dictsproto.TIataCorrection)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("IataCorrection:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.idToIataCorrection[model.ID] = &model
	return len(b), nil
}

func (ref *IataCorrection) convertProtoReferenceToModel(proto *dictsproto.TIataCorrection) (reference models.IataCorrection) {
	reference.ID = int(proto.Id)
	reference.Code = proto.Code
	reference.Number = proto.Number
	reference.CompanyID = int(proto.CompanyId)
	return
}
