package references

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/avia/wizard/pkg/wizard/domain/models"
	dictsproto "a.yandex-team.ru/travel/proto/dicts/avia"
)

type Region struct {
	regions []*models.Region
}

func (ref *Region) GetAll() []*models.Region {
	return ref.regions
}

func NewRegion() *Region {
	return &Region{
		regions: make([]*models.Region, 0),
	}
}

func (ref *Region) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewRegion()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*ref = *newState
	return nil
}

func (ref *Region) Write(b []byte) (int, error) {
	message := new(dictsproto.TRegion)
	if err := proto.Unmarshal(b, message); err != nil {
		return 0, fmt.Errorf("Region:Write: %w", err)
	}
	model := ref.convertProtoReferenceToModel(message)
	ref.regions = append(ref.regions, model)
	return len(b), nil
}

func (ref *Region) convertProtoReferenceToModel(proto *dictsproto.TRegion) *models.Region {
	reference := new(models.Region)
	reference.ID = int(proto.Id)
	reference.Title = proto.Title
	reference.GeoID = int(proto.GeoId)
	reference.NewLTitleID = int(proto.NewLTitleID)
	reference.TimeZone = proto.TimeZone
	return reference
}
